<?php 

class User
{
	private $conn;

	public $id;
	public $email;
	public $password;
	public $userType;
	public $accessType;

	public function __construct($db)
		{
			$this->conn = $db;
		}

//---------------- Start of readUser.php Functions
	public function getAllUsers()
	{
		$query = "SELECT * FROM users WHERE userType ='User' ";
		$stmt = $this->conn->prepare($query);
		$stmt->execute();
		return $stmt;
	}	

	public function getUserStatus()
	{
		$query = "SELECT * FROM users WHERE id = :id";
		$stmt = $this->conn->prepare($query);
		$stmt->bindParam(':id',$this->id);
		$stmt->execute();
		return $stmt;
	}
//---------------- End of readUser.php Functions
	
	public function updateAccessType()
	{
		$query = "UPDATE users SET accessType = :accessType 
		WHERE id = :id";
		$stmt = $this->conn->prepare($query);
		$this->id = htmlspecialchars(strip_tags($this->id));
		$this->accessType = htmlspecialchars(strip_tags($this->accessType));
		$stmt->bindParam(':id',$this->id);
		$stmt->bindParam(':accessType',$this->accessType);

		if($stmt->execute())
		{
			return true;
		}

		print_f("Error %s .\n",$stmt->error);
		return false;

	}


	public function signIn()
	{
		$query = "SELECT id FROM users 
		WHERE email = :email && password = :password";

		$stmt = $this->conn->prepare($query);
		$this->email = htmlspecialchars(strip_tags($this->email));
		$this->password = htmlspecialchars(strip_tags($this->password));
		$stmt->bindParam(':email',$this->email);
		$stmt->bindParam(':password',$this->password);
		if($stmt->execute())
		{
			return true;
		}

		print_f("Error %s .\n",$stmt->error);
			return false;

	}

	public function signUp()
	{
		$query = "INSERT INTO users 
		(email,password,userType,accessType)
		VALUES (:email,:password,:'User','Limited')";

		$this->email = htmlspecialchars(strip_tags($this->email));
		$this->password = htmlspecialchars(strip_tags($this->password));
		$stmt->bindParam(':email',$this->email);
		$stmt->bindParam(':password',$this->password);

		
			if($stmt->execute())
			{
				return true;
			}
			print_f("Error %s .\n",$stmt->error);
			return false;

	}


}

 ?>